/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.tile.floor;

import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.IntSet;
import technology.rocketjump.undermount.mapping.tile.floor.OverlapLayout;

public class OverlapLayoutAtlas {
    IntMap<OverlapAtlasEntry> library = new IntMap(512);
    IntSet uniqueLayoutIds = new IntSet(64);

    public OverlapLayoutAtlas() {
        for (int layoutId = 0; layoutId < 256; ++layoutId) {
            OverlapLayout layoutForId = new OverlapLayout(layoutId);
            OverlapLayout simplified = layoutForId.reduceToMeaningfulForm();
            if (this.uniqueLayoutIds.contains(simplified.getId())) {
                this.library.put(layoutId, new OverlapAtlasEntry(simplified));
                continue;
            }
            OverlapLayout flippedX = new OverlapLayout(simplified.getId()).flipX();
            if (this.uniqueLayoutIds.contains(flippedX.getId())) {
                this.library.put(layoutId, new OverlapAtlasEntry(flippedX, true, false, simplified));
                continue;
            }
            OverlapLayout flippedY = new OverlapLayout(simplified.getId()).flipY();
            if (this.uniqueLayoutIds.contains(flippedY.getId())) {
                this.library.put(layoutId, new OverlapAtlasEntry(flippedY, false, true, simplified));
                continue;
            }
            OverlapLayout flippedXY = new OverlapLayout(simplified.getId()).flipX().flipY();
            if (this.uniqueLayoutIds.contains(flippedXY.getId())) {
                this.library.put(layoutId, new OverlapAtlasEntry(flippedXY, true, true, simplified));
                continue;
            }
            this.library.put(layoutId, new OverlapAtlasEntry(simplified));
            this.uniqueLayoutIds.add(simplified.getId());
        }
    }

    public OverlapAtlasEntry getByLayoutId(int layoutId) {
        return this.library.get(layoutId);
    }

    public IntSet getUniqueLayoutIds() {
        return this.uniqueLayoutIds;
    }

    public static class OverlapAtlasEntry {
        private final OverlapLayout layout;
        private final boolean flipX;
        private final boolean flipY;
        private final OverlapLayout unflippedLayout;

        public OverlapAtlasEntry(OverlapLayout layout, boolean flipX, boolean flipY, OverlapLayout unflippedLayout) {
            this.layout = layout;
            this.flipX = flipX;
            this.flipY = flipY;
            this.unflippedLayout = unflippedLayout;
        }

        public OverlapAtlasEntry(OverlapLayout layout) {
            this.layout = layout;
            this.flipX = false;
            this.flipY = false;
            this.unflippedLayout = layout;
        }

        public OverlapLayout getLayout() {
            return this.layout;
        }

        public OverlapLayout getUnflippedLayout() {
            return this.unflippedLayout;
        }

        public boolean isFlipX() {
            return this.flipX;
        }

        public boolean isFlipY() {
            return this.flipY;
        }
    }
}

